/*----------------------------------------------------------------------------
 * Name:    led.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"led.h"

typedef struct __attribute__((packed))
{
	HT_GPIO_TypeDef *prot;
	u32				 pin;
}tLED_CTRL;

const tLED_CTRL	LEDPort[MAX_LED_NUM] = 
{
	{LED1_PORT, LED1_IO},
	{LED2_PORT, LED2_IO},
	{LED3_PORT, LED3_IO},
	{LED4_PORT, LED4_IO},
	{LEDP_PORT, LEDP_IO}
};
u16	LEDFlashTimer[MAX_LED_NUM];
u16	LEDFlashTmCnt[MAX_LED_NUM];

/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_InterfaceConfigure(void)
{
	
   /* configure LED as GPIO  */   
   AFIO_GPxConfig(LED1_AFIO_PORT, LED1_IO, LED1_AFIO_FUN);
   AFIO_GPxConfig(LED2_AFIO_PORT, LED2_IO, LED2_AFIO_FUN);
   AFIO_GPxConfig(LED3_AFIO_PORT, LED3_IO, LED3_AFIO_FUN);
   AFIO_GPxConfig(LED4_AFIO_PORT, LED4_IO, LED4_AFIO_FUN);
// AFIO_GPxConfig(LEDP_AFIO_PORT, LEDP_IO, LEDP_AFIO_FUN);	
   /* configure LED as OUT mode  */
   GPIO_DirectionConfig(LED1_PORT, LED1_IO, GPIO_DIR_OUT);
   GPIO_DirectionConfig(LED2_PORT, LED2_IO, GPIO_DIR_OUT);
   GPIO_DirectionConfig(LED3_PORT, LED3_IO, GPIO_DIR_OUT);
   GPIO_DirectionConfig(LED4_PORT, LED4_IO, GPIO_DIR_OUT);
// GPIO_DirectionConfig(LEDP_PORT, LEDP_IO, GPIO_DIR_OUT);
   /* configure LED1 driving current = 12mA  */
   GPIO_DriveConfig(LED1_PORT, LED1_IO, GPIO_DV_16MA);
   GPIO_DriveConfig(LED2_PORT, LED2_IO, GPIO_DV_16MA);
   GPIO_DriveConfig(LED3_PORT, LED3_IO, GPIO_DV_16MA);
   GPIO_DriveConfig(LED4_PORT, LED4_IO, GPIO_DV_16MA);
// GPIO_DriveConfig(LEDP_PORT, LEDP_IO, GPIO_DV_16MA);
	
	LED1_OFF();
	LED2_OFF();
	LED3_OFF();
	LED4_OFF();	
	LEDP_OFF();
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_AlwaysON(u8 led)
{	
	if(led == LED1)		
	{
		LEDFlashTimer[0] = 0;
		LED1_ON();		
	}
	
	if(led == LED2)
	{
		LEDFlashTimer[1] = 0;
		LED2_ON();
	}
	if(led == LED3)		
	{
		LEDFlashTimer[2] = 0;
		LED3_ON();		
	}
	
	if(led == LED4)
	{
		LEDFlashTimer[3] = 0;
		LED4_ON();
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_AlwaysOFF(u8 led)
{
	if(led == LED1)				
	{
		LEDFlashTimer[0] = 0;
		LED1_OFF();		
	}
	
	if(led == LED2)					
	{
		LEDFlashTimer[1] = 0;
		LED2_OFF();
	}
	if(led == LED3)				
	{
		LEDFlashTimer[2] = 0;
		LED3_OFF();		
	}
	
	if(led == LED4)					
	{
		LEDFlashTimer[3] = 0;
		LED4_OFF();
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_FlashEnable(u8 led,u16 timer)
{
	if(led == LED1)					
	{
		LEDFlashTimer[0] = LEDFlashTmCnt[0] = timer;
		LED1_ON();		
	}	
	if(led == LED2)				
	{
		LEDFlashTimer[1] = LEDFlashTmCnt[1] = timer;
		LED2_ON();
	}
	if(led == LED3)					
	{
		LEDFlashTimer[2] = LEDFlashTmCnt[2] = timer;
		LED3_ON();		
	}	
	if(led == LED4)				
	{
		LEDFlashTimer[3] = LEDFlashTmCnt[3] = timer;
		LED4_ON();
	}	
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_FlashProcess(void)
{
	if(LEDFlashTimer[0])
	{
		if(--LEDFlashTmCnt[0] == 0)
		{
			LEDFlashTmCnt[0] = LEDFlashTimer[0];
			LED1_TOGGLE();																															  
		}
	}
	if(LEDFlashTimer[1])
	{
		if(--LEDFlashTmCnt[1] == 0)
		{
			LEDFlashTmCnt[1] = LEDFlashTimer[1];
			LED2_TOGGLE();
		}
	}	
	if(LEDFlashTimer[2])
	{
		if(--LEDFlashTmCnt[2] == 0)
		{
			LEDFlashTmCnt[2] = LEDFlashTimer[2];
			LED3_TOGGLE();
		}
	}
	if(LEDFlashTimer[3])
	{
		if(--LEDFlashTmCnt[3] == 0)
		{
			LEDFlashTmCnt[3] = LEDFlashTimer[3];
			LED4_TOGGLE();
		}
	}
}

/*****************************************************************************************************
* @brief  Set LED Flag and timer counter for LEDProcess_ms(); use
* @retval None
*******************************************************************************************************/
u8 F_LED1 = 0;
u8 F_LED2 = 0;
u8 F_LED3 = 0;
u8 F_LED4 = 0;
u16 LED1_CounterLimit = 0;
u16 LED2_CounterLimit = 0;
u16 LED3_CounterLimit = 0;
u16 LED4_CounterLimit = 0;
void LED_EnableFlag_ms(u8 led,u16 timer)
{
	if(led == 1)					
	{
		F_LED1 = 1;
		LED1_CounterLimit = timer;
	}	
	if(led == 2)				
	{
		F_LED2 = 1;
		LED2_CounterLimit = timer;
	}
	if(led == 3)					
	{
		F_LED3 = 1;
		LED3_CounterLimit = timer;	
	}	
	if(led == 4)				
	{
		F_LED4 = 1;
		LED4_CounterLimit = timer;
	}
}

/*****************************************************************************************************
* @brief  LED Process with timer
* @retval None
*******************************************************************************************************/
u16 LED1_Counter = 0;
u16 LED2_Counter = 0;
u16 LED3_Counter = 0;
u16 LED4_Counter = 0;
void LEDProcess_ms(void)
{	
	if(F_LED1 == 1)
	{
		LED1_ON();
		LED1_Counter++;
		if(LED1_Counter > LED1_CounterLimit)
		{
			F_LED1 = 0;
			LED1_Counter = 0;
		}
	}
	else
		LED1_OFF();
	
	if(F_LED2 == 1)
	{
		LED2_ON();
		LED2_Counter++;
		if(LED2_Counter > LED2_CounterLimit)
		{
			F_LED2 = 0;
			LED2_Counter = 0;
		}
	}
	else
		LED2_OFF();
	
	if(F_LED3 == 1)
	{
		LED3_ON();
		LED3_Counter++;
		if(LED3_Counter > LED3_CounterLimit)
		{
			F_LED3 = 0;
			LED3_Counter = 0;
		}
	}
	else
		LED3_OFF();
	
	if(F_LED4 == 1)
	{
		LED4_ON();
		LED4_Counter++;
		if(LED4_Counter > LED4_CounterLimit)
		{
			F_LED4 = 0;
			LED4_Counter = 0;
		}
	}
	else
		LED4_OFF();
}
